/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import noppes.npcs.api.IGlStateManager;
import noppes.npcs.api.IMinecraft;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.wrapper.WrapperGlStateManager;

public class WrapperMinecraft
implements IMinecraft {
    private final Minecraft minecraft;
    private final IGlStateManager glStateManager;

    public WrapperMinecraft(Minecraft mc) {
        this.minecraft = mc;
        this.glStateManager = new WrapperGlStateManager(mc);
    }

    @Override
    public Minecraft getMc() {
        return this.minecraft;
    }

    @Override
    public GuiScreen getCurrentScreen() {
        return this.minecraft.field_71462_r;
    }

    @Override
    public int getDisplayWidth() {
        return this.minecraft.field_71443_c;
    }

    @Override
    public int getDisplayHeight() {
        return this.minecraft.field_71440_d;
    }

    @Override
    public float getRenderPartialTicks() {
        return this.minecraft.func_184121_ak();
    }

    @Override
    public IResourceManager getResourceManager() {
        return this.minecraft.func_110442_L();
    }

    @Override
    public TextureManager getTextureManager() {
        return this.minecraft.func_110434_K();
    }

    @Override
    public SoundHandler getSoundHandler() {
        return this.minecraft.func_147118_V();
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.minecraft.func_175597_ag();
    }

    @Override
    public double getWidth() {
        return new ScaledResolution(this.minecraft).func_78327_c();
    }

    @Override
    public double getHeight() {
        return new ScaledResolution(this.minecraft).func_78324_d();
    }

    @Override
    public IGlStateManager getGlStateManager() {
        return this.glStateManager;
    }

    @Override
    public void playSound(String category, String sound, float x, float y, float z, float volume, float pitch) {
        if (sound == null || sound.isEmpty()) {
            return;
        }
        if (y < 0.0f && this.minecraft.field_71439_g != null) {
            x = (float)this.minecraft.field_71439_g.field_70165_t;
            y = (float)this.minecraft.field_71439_g.field_70163_u + 0.9f;
            z = (float)this.minecraft.field_71439_g.field_70161_v;
        }
        ISound.AttenuationType aType = ISound.AttenuationType.LINEAR;
        SoundCategory cat = this.getCategory(category);
        if (cat == SoundCategory.MUSIC || this.minecraft.field_71441_e == null) {
            if (cat == SoundCategory.MUSIC) {
                this.getSoundHandler().func_189520_a("", SoundCategory.MUSIC);
            }
            aType = ISound.AttenuationType.NONE;
            x = this.minecraft.field_71439_g != null ? (float)this.minecraft.field_71439_g.field_70165_t : 0.0f;
            y = this.minecraft.field_71439_g != null ? (float)this.minecraft.field_71439_g.field_70163_u + 0.5f : 0.0f;
            z = this.minecraft.field_71439_g != null ? (float)this.minecraft.field_71439_g.field_70161_v : 0.0f;
        }
        this.getSoundHandler().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(sound), cat, volume, pitch, false, 0, aType, x, y, z));
    }

    @Override
    public void stopSound(String category, String sound) {
        if (sound == null) {
            sound = "";
        }
        this.getSoundHandler().func_189520_a(sound, this.getCategory(category));
    }

    @Override
    public GameSettings getGameSettings() {
        return this.minecraft.field_71474_y;
    }

    @Override
    public float getSoundVolume(String category) {
        return this.minecraft.field_71474_y.func_186711_a(this.getCategory(category));
    }

    @Override
    public void setSoundVolume(String category, float volume) {
        this.minecraft.field_71474_y.func_186712_a(this.getCategory(category), volume);
    }

    @Override
    public IPlayer<?> getPlayer() {
        return (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.minecraft.field_71439_g);
    }

    private SoundCategory getCategory(String category) {
        if (category != null && !category.isEmpty()) {
            for (SoundCategory c : SoundCategory.values()) {
                if (!c.func_187948_a().equalsIgnoreCase(category)) continue;
                return c;
            }
        }
        return SoundCategory.AMBIENT;
    }
}

